CREATE EXTENSION IF NOT EXISTS "pg_graphql";
CREATE EXTENSION IF NOT EXISTS "pg_stat_statements" WITH SCHEMA "extensions";
CREATE EXTENSION IF NOT EXISTS "pgcrypto" WITH SCHEMA "extensions";
CREATE EXTENSION IF NOT EXISTS "plpgsql";
CREATE EXTENSION IF NOT EXISTS "supabase_vault";
CREATE EXTENSION IF NOT EXISTS "uuid-ossp" WITH SCHEMA "extensions";
BEGIN;

--
-- PostgreSQL database dump
--


-- Dumped from database version 17.6
-- Dumped by pg_dump version 18.1

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET transaction_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: public; Type: SCHEMA; Schema: -; Owner: -
--



--
-- Name: activity_direction; Type: TYPE; Schema: public; Owner: -
--

CREATE TYPE public.activity_direction AS ENUM (
    'inbound',
    'outbound',
    'log'
);


--
-- Name: activity_type; Type: TYPE; Schema: public; Owner: -
--

CREATE TYPE public.activity_type AS ENUM (
    'email',
    'sms',
    'call',
    'system'
);


--
-- Name: app_role; Type: TYPE; Schema: public; Owner: -
--

CREATE TYPE public.app_role AS ENUM (
    'admin',
    'manager',
    'user'
);


--
-- Name: contact_status; Type: TYPE; Schema: public; Owner: -
--

CREATE TYPE public.contact_status AS ENUM (
    'lead',
    'prospect',
    'customer',
    'churned'
);


--
-- Name: custom_field_type; Type: TYPE; Schema: public; Owner: -
--

CREATE TYPE public.custom_field_type AS ENUM (
    'text',
    'number',
    'date',
    'boolean',
    'select'
);


--
-- Name: task_priority; Type: TYPE; Schema: public; Owner: -
--

CREATE TYPE public.task_priority AS ENUM (
    'low',
    'medium',
    'high'
);


--
-- Name: task_status; Type: TYPE; Schema: public; Owner: -
--

CREATE TYPE public.task_status AS ENUM (
    'pending',
    'completed',
    'overdue'
);


--
-- Name: task_type; Type: TYPE; Schema: public; Owner: -
--

CREATE TYPE public.task_type AS ENUM (
    'call',
    'email',
    'meeting',
    'follow-up',
    'other'
);


--
-- Name: handle_new_user(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.handle_new_user() RETURNS trigger
    LANGUAGE plpgsql SECURITY DEFINER
    SET search_path TO 'public'
    AS $$
BEGIN
  INSERT INTO public.profiles (id, email, name)
  VALUES (NEW.id, NEW.email, COALESCE(NEW.raw_user_meta_data->>'name', split_part(NEW.email, '@', 1)));
  
  INSERT INTO public.user_roles (user_id, role)
  VALUES (NEW.id, 'user');
  
  RETURN NEW;
END;
$$;


--
-- Name: has_role(uuid, public.app_role); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.has_role(_user_id uuid, _role public.app_role) RETURNS boolean
    LANGUAGE sql STABLE SECURITY DEFINER
    SET search_path TO 'public'
    AS $$
  SELECT EXISTS (
    SELECT 1
    FROM public.user_roles
    WHERE user_id = _user_id
      AND role = _role
  )
$$;


--
-- Name: update_updated_at_column(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.update_updated_at_column() RETURNS trigger
    LANGUAGE plpgsql
    SET search_path TO 'public'
    AS $$
BEGIN
  NEW.updated_at = now();
  RETURN NEW;
END;
$$;


SET default_table_access_method = heap;

--
-- Name: activities; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.activities (
    id uuid DEFAULT gen_random_uuid() NOT NULL,
    contact_id uuid,
    user_id uuid NOT NULL,
    type public.activity_type NOT NULL,
    direction public.activity_direction DEFAULT 'log'::public.activity_direction NOT NULL,
    subject text,
    body_preview text,
    status text DEFAULT 'logged'::text NOT NULL,
    created_at timestamp with time zone DEFAULT now() NOT NULL,
    category text DEFAULT 'user'::text NOT NULL,
    property_id uuid,
    CONSTRAINT activities_entity_check CHECK (((contact_id IS NOT NULL) OR (property_id IS NOT NULL)))
);


--
-- Name: attachments; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.attachments (
    id uuid DEFAULT gen_random_uuid() NOT NULL,
    contact_id uuid,
    file_name text NOT NULL,
    file_path text NOT NULL,
    file_size integer NOT NULL,
    mime_type text NOT NULL,
    category text DEFAULT 'general'::text NOT NULL,
    uploaded_by uuid NOT NULL,
    created_at timestamp with time zone DEFAULT now() NOT NULL,
    updated_at timestamp with time zone DEFAULT now() NOT NULL,
    entity_type text DEFAULT 'contact'::text,
    entity_id uuid,
    property_id uuid,
    tenancy_id uuid
);


--
-- Name: business; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.business (
    id uuid DEFAULT gen_random_uuid() NOT NULL,
    name text NOT NULL,
    location text,
    address text,
    city text,
    state text,
    postal_code text,
    country text,
    industries text[],
    phone text,
    email text,
    website text,
    owner_name text,
    owner_email text,
    owner_phone text,
    logo_url text,
    preferred_theme text DEFAULT 'system'::text,
    preferred_accent_color text DEFAULT 'blue'::text,
    preferred_layout text DEFAULT 'sidebar'::text,
    created_at timestamp with time zone DEFAULT now() NOT NULL,
    updated_at timestamp with time zone DEFAULT now() NOT NULL
);


--
-- Name: business_email_config; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.business_email_config (
    id uuid DEFAULT gen_random_uuid() NOT NULL,
    business_id uuid,
    provider text DEFAULT 'smtp'::text NOT NULL,
    smtp_host text,
    smtp_port integer DEFAULT 587,
    smtp_username text,
    smtp_password text,
    smtp_encryption text DEFAULT 'tls'::text,
    from_email text,
    from_name text,
    reply_to_email text,
    is_active boolean DEFAULT false NOT NULL,
    created_at timestamp with time zone DEFAULT now() NOT NULL,
    updated_at timestamp with time zone DEFAULT now() NOT NULL
);


--
-- Name: contact_custom_values; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.contact_custom_values (
    id uuid DEFAULT gen_random_uuid() NOT NULL,
    contact_id uuid NOT NULL,
    custom_field_id uuid NOT NULL,
    value text,
    created_at timestamp with time zone DEFAULT now() NOT NULL,
    updated_at timestamp with time zone DEFAULT now() NOT NULL
);


--
-- Name: contact_tags; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.contact_tags (
    id uuid DEFAULT gen_random_uuid() NOT NULL,
    contact_id uuid NOT NULL,
    tag_id uuid NOT NULL,
    created_at timestamp with time zone DEFAULT now() NOT NULL
);


--
-- Name: contacts; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.contacts (
    id uuid DEFAULT gen_random_uuid() NOT NULL,
    first_name text NOT NULL,
    last_name text NOT NULL,
    email text NOT NULL,
    phone text,
    company text,
    status public.contact_status DEFAULT 'lead'::public.contact_status NOT NULL,
    owner_id uuid,
    pipeline_id uuid,
    stage_id uuid,
    source text,
    created_at timestamp with time zone DEFAULT now() NOT NULL,
    updated_at timestamp with time zone DEFAULT now() NOT NULL,
    deleted_at timestamp with time zone,
    deleted_by uuid,
    deleted_from text,
    avatar_url text
);


--
-- Name: custom_fields; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.custom_fields (
    id uuid DEFAULT gen_random_uuid() NOT NULL,
    entity_type text DEFAULT 'contact'::text NOT NULL,
    name text NOT NULL,
    label text NOT NULL,
    field_type public.custom_field_type DEFAULT 'text'::public.custom_field_type NOT NULL,
    options jsonb,
    is_required boolean DEFAULT false NOT NULL,
    is_active boolean DEFAULT true NOT NULL,
    sort_order integer DEFAULT 0 NOT NULL,
    created_at timestamp with time zone DEFAULT now() NOT NULL,
    updated_at timestamp with time zone DEFAULT now() NOT NULL
);


--
-- Name: email_templates; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.email_templates (
    id uuid DEFAULT gen_random_uuid() NOT NULL,
    name text NOT NULL,
    subject text NOT NULL,
    body text NOT NULL,
    description text,
    is_active boolean DEFAULT true NOT NULL,
    created_at timestamp with time zone DEFAULT now() NOT NULL,
    updated_at timestamp with time zone DEFAULT now() NOT NULL
);


--
-- Name: notes; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.notes (
    id uuid DEFAULT gen_random_uuid() NOT NULL,
    contact_id uuid NOT NULL,
    author_id uuid NOT NULL,
    content text NOT NULL,
    created_at timestamp with time zone DEFAULT now() NOT NULL,
    updated_at timestamp with time zone DEFAULT now() NOT NULL
);


--
-- Name: pipeline_stages; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.pipeline_stages (
    id uuid DEFAULT gen_random_uuid() NOT NULL,
    pipeline_id uuid NOT NULL,
    name text NOT NULL,
    order_index integer DEFAULT 0 NOT NULL,
    probability integer,
    color text,
    created_at timestamp with time zone DEFAULT now() NOT NULL,
    updated_at timestamp with time zone DEFAULT now() NOT NULL
);


--
-- Name: pipelines; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.pipelines (
    id uuid DEFAULT gen_random_uuid() NOT NULL,
    name text NOT NULL,
    description text,
    is_default boolean DEFAULT false NOT NULL,
    created_at timestamp with time zone DEFAULT now() NOT NULL,
    updated_at timestamp with time zone DEFAULT now() NOT NULL
);


--
-- Name: profiles; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.profiles (
    id uuid NOT NULL,
    email text NOT NULL,
    name text,
    avatar_url text,
    created_at timestamp with time zone DEFAULT now() NOT NULL,
    updated_at timestamp with time zone DEFAULT now() NOT NULL
);


--
-- Name: properties; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.properties (
    id uuid DEFAULT gen_random_uuid() NOT NULL,
    property_class text,
    business_category text,
    reference text,
    display_address text,
    address_line_1 text,
    address_line_2 text,
    town_city text,
    county text,
    postcode text,
    country text DEFAULT 'United Kingdom'::text,
    is_overseas boolean DEFAULT false,
    headline text,
    summary text,
    full_description text,
    branch text,
    lead_staff text,
    price numeric(12,2),
    price_qualifier text,
    valuation_price numeric(12,2),
    minimum_acceptable_price numeric(12,2),
    on_the_market boolean DEFAULT false,
    put_on_market timestamp with time zone,
    marketing_tag text,
    virtual_tour_link text,
    virtual_tour_link_2 text,
    link_on_website text,
    rightmove_link text,
    zoopla_link text,
    on_the_market_link text,
    epc_rating text,
    epc_band text,
    additional_information text,
    dashboard_note text,
    viewing_arrangements text,
    ground_rent numeric(10,2),
    maintenance_charge numeric(10,2),
    exclude_from_all_portals boolean DEFAULT false,
    exclude_from_website boolean DEFAULT false,
    exclude_from_window_rotator boolean DEFAULT false,
    feature_on_homepage boolean DEFAULT false,
    local_authority text,
    additional_field_1 text,
    additional_field_2 text,
    property_type text,
    number_of_bedrooms integer,
    number_of_receptions integer,
    number_of_bathrooms integer,
    council_tax_band text,
    landlord_id uuid,
    status text DEFAULT 'available'::text,
    date_available date,
    deposit numeric(10,2),
    letting_service text,
    letting_fee numeric(10,2),
    management_fee numeric(10,2),
    landlord_payment_frequency text,
    has_gas boolean DEFAULT false,
    gas_certificate_expiry date,
    pat_test_expiry date,
    electricity_certificate_expiry date,
    epc_expiry date,
    insurance_expiry date,
    legionella_risk_assessment_date date,
    smoke_co_alarm_expiry date,
    property_licence_expiry date,
    property_licence_type text,
    property_licence_notes text,
    deleted_at timestamp with time zone,
    deleted_by uuid,
    created_at timestamp with time zone DEFAULT now() NOT NULL,
    updated_at timestamp with time zone DEFAULT now() NOT NULL
);


--
-- Name: property_notes; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.property_notes (
    id uuid DEFAULT gen_random_uuid() NOT NULL,
    property_id uuid NOT NULL,
    author_id uuid NOT NULL,
    content text NOT NULL,
    created_at timestamp with time zone DEFAULT now() NOT NULL,
    updated_at timestamp with time zone DEFAULT now() NOT NULL
);


--
-- Name: rent_payments; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.rent_payments (
    id uuid DEFAULT gen_random_uuid() NOT NULL,
    tenancy_id uuid NOT NULL,
    amount numeric NOT NULL,
    due_date date NOT NULL,
    payment_date date,
    payment_method text,
    reference text,
    status text DEFAULT 'pending'::text NOT NULL,
    notes text,
    created_at timestamp with time zone DEFAULT now() NOT NULL,
    updated_at timestamp with time zone DEFAULT now() NOT NULL,
    CONSTRAINT rent_payments_status_check CHECK ((status = ANY (ARRAY['pending'::text, 'paid'::text, 'partial'::text, 'overdue'::text, 'waived'::text])))
);


--
-- Name: tags; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.tags (
    id uuid DEFAULT gen_random_uuid() NOT NULL,
    name text NOT NULL,
    color text DEFAULT '#6366f1'::text NOT NULL,
    description text,
    created_at timestamp with time zone DEFAULT now() NOT NULL,
    updated_at timestamp with time zone DEFAULT now() NOT NULL
);


--
-- Name: tasks; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.tasks (
    id uuid DEFAULT gen_random_uuid() NOT NULL,
    contact_id uuid,
    owner_id uuid NOT NULL,
    title text NOT NULL,
    description text,
    due_date timestamp with time zone,
    completed_at timestamp with time zone,
    status public.task_status DEFAULT 'pending'::public.task_status NOT NULL,
    priority public.task_priority DEFAULT 'medium'::public.task_priority NOT NULL,
    type public.task_type DEFAULT 'other'::public.task_type NOT NULL,
    created_at timestamp with time zone DEFAULT now() NOT NULL,
    updated_at timestamp with time zone DEFAULT now() NOT NULL
);


--
-- Name: tenancies; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.tenancies (
    id uuid DEFAULT gen_random_uuid() NOT NULL,
    reference text,
    property_id uuid,
    tenant_id uuid,
    start_date date,
    end_date date,
    rent numeric,
    rent_payment_frequency text,
    deposit numeric,
    where_deposit_held text,
    letting_service text,
    status text DEFAULT 'active'::text,
    letting_fee numeric,
    management_fee numeric,
    is_periodic boolean DEFAULT false,
    rent_review_date date,
    branch text,
    is_rent_guaranteed boolean DEFAULT false,
    tenancy_agreement_special_clause text,
    renewal text,
    is_hmo boolean DEFAULT false,
    break_clause text,
    notice_period text,
    lead_staff text,
    deleted_at timestamp with time zone,
    deleted_by uuid,
    created_at timestamp with time zone DEFAULT now() NOT NULL,
    updated_at timestamp with time zone DEFAULT now() NOT NULL
);


--
-- Name: user_roles; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.user_roles (
    id uuid DEFAULT gen_random_uuid() NOT NULL,
    user_id uuid NOT NULL,
    role public.app_role DEFAULT 'user'::public.app_role NOT NULL,
    created_at timestamp with time zone DEFAULT now() NOT NULL
);


--
-- Name: activities activities_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.activities
    ADD CONSTRAINT activities_pkey PRIMARY KEY (id);


--
-- Name: attachments attachments_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.attachments
    ADD CONSTRAINT attachments_pkey PRIMARY KEY (id);


--
-- Name: business_email_config business_email_config_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.business_email_config
    ADD CONSTRAINT business_email_config_pkey PRIMARY KEY (id);


--
-- Name: business business_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.business
    ADD CONSTRAINT business_pkey PRIMARY KEY (id);


--
-- Name: contact_custom_values contact_custom_values_contact_id_custom_field_id_key; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.contact_custom_values
    ADD CONSTRAINT contact_custom_values_contact_id_custom_field_id_key UNIQUE (contact_id, custom_field_id);


--
-- Name: contact_custom_values contact_custom_values_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.contact_custom_values
    ADD CONSTRAINT contact_custom_values_pkey PRIMARY KEY (id);


--
-- Name: contact_tags contact_tags_contact_id_tag_id_key; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.contact_tags
    ADD CONSTRAINT contact_tags_contact_id_tag_id_key UNIQUE (contact_id, tag_id);


--
-- Name: contact_tags contact_tags_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.contact_tags
    ADD CONSTRAINT contact_tags_pkey PRIMARY KEY (id);


--
-- Name: contacts contacts_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.contacts
    ADD CONSTRAINT contacts_pkey PRIMARY KEY (id);


--
-- Name: custom_fields custom_fields_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.custom_fields
    ADD CONSTRAINT custom_fields_pkey PRIMARY KEY (id);


--
-- Name: email_templates email_templates_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.email_templates
    ADD CONSTRAINT email_templates_pkey PRIMARY KEY (id);


--
-- Name: notes notes_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.notes
    ADD CONSTRAINT notes_pkey PRIMARY KEY (id);


--
-- Name: pipeline_stages pipeline_stages_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.pipeline_stages
    ADD CONSTRAINT pipeline_stages_pkey PRIMARY KEY (id);


--
-- Name: pipelines pipelines_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.pipelines
    ADD CONSTRAINT pipelines_pkey PRIMARY KEY (id);


--
-- Name: profiles profiles_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.profiles
    ADD CONSTRAINT profiles_pkey PRIMARY KEY (id);


--
-- Name: properties properties_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.properties
    ADD CONSTRAINT properties_pkey PRIMARY KEY (id);


--
-- Name: property_notes property_notes_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.property_notes
    ADD CONSTRAINT property_notes_pkey PRIMARY KEY (id);


--
-- Name: rent_payments rent_payments_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.rent_payments
    ADD CONSTRAINT rent_payments_pkey PRIMARY KEY (id);


--
-- Name: tags tags_name_unique; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.tags
    ADD CONSTRAINT tags_name_unique UNIQUE (name);


--
-- Name: tags tags_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.tags
    ADD CONSTRAINT tags_pkey PRIMARY KEY (id);


--
-- Name: tasks tasks_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.tasks
    ADD CONSTRAINT tasks_pkey PRIMARY KEY (id);


--
-- Name: tenancies tenancies_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.tenancies
    ADD CONSTRAINT tenancies_pkey PRIMARY KEY (id);


--
-- Name: user_roles user_roles_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.user_roles
    ADD CONSTRAINT user_roles_pkey PRIMARY KEY (id);


--
-- Name: user_roles user_roles_user_id_role_key; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.user_roles
    ADD CONSTRAINT user_roles_user_id_role_key UNIQUE (user_id, role);


--
-- Name: idx_activities_category; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_activities_category ON public.activities USING btree (category);


--
-- Name: idx_activities_property_id; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_activities_property_id ON public.activities USING btree (property_id) WHERE (property_id IS NOT NULL);


--
-- Name: idx_attachments_entity; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_attachments_entity ON public.attachments USING btree (entity_type, entity_id);


--
-- Name: idx_attachments_property_id; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_attachments_property_id ON public.attachments USING btree (property_id);


--
-- Name: idx_attachments_tenancy_id; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_attachments_tenancy_id ON public.attachments USING btree (tenancy_id);


--
-- Name: idx_properties_landlord_id; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_properties_landlord_id ON public.properties USING btree (landlord_id);


--
-- Name: idx_properties_status; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_properties_status ON public.properties USING btree (status);


--
-- Name: idx_property_notes_property_id; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_property_notes_property_id ON public.property_notes USING btree (property_id);


--
-- Name: idx_rent_payments_due_date; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_rent_payments_due_date ON public.rent_payments USING btree (due_date);


--
-- Name: idx_rent_payments_status; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_rent_payments_status ON public.rent_payments USING btree (status);


--
-- Name: idx_rent_payments_tenancy_id; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_rent_payments_tenancy_id ON public.rent_payments USING btree (tenancy_id);


--
-- Name: idx_tenancies_deleted_at; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_tenancies_deleted_at ON public.tenancies USING btree (deleted_at);


--
-- Name: idx_tenancies_property_id; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_tenancies_property_id ON public.tenancies USING btree (property_id);


--
-- Name: idx_tenancies_status; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_tenancies_status ON public.tenancies USING btree (status);


--
-- Name: idx_tenancies_tenant_id; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_tenancies_tenant_id ON public.tenancies USING btree (tenant_id);


--
-- Name: business_email_config update_business_email_config_updated_at; Type: TRIGGER; Schema: public; Owner: -
--

CREATE TRIGGER update_business_email_config_updated_at BEFORE UPDATE ON public.business_email_config FOR EACH ROW EXECUTE FUNCTION public.update_updated_at_column();


--
-- Name: business update_business_updated_at; Type: TRIGGER; Schema: public; Owner: -
--

CREATE TRIGGER update_business_updated_at BEFORE UPDATE ON public.business FOR EACH ROW EXECUTE FUNCTION public.update_updated_at_column();


--
-- Name: email_templates update_email_templates_updated_at; Type: TRIGGER; Schema: public; Owner: -
--

CREATE TRIGGER update_email_templates_updated_at BEFORE UPDATE ON public.email_templates FOR EACH ROW EXECUTE FUNCTION public.update_updated_at_column();


--
-- Name: properties update_properties_updated_at; Type: TRIGGER; Schema: public; Owner: -
--

CREATE TRIGGER update_properties_updated_at BEFORE UPDATE ON public.properties FOR EACH ROW EXECUTE FUNCTION public.update_updated_at_column();


--
-- Name: property_notes update_property_notes_updated_at; Type: TRIGGER; Schema: public; Owner: -
--

CREATE TRIGGER update_property_notes_updated_at BEFORE UPDATE ON public.property_notes FOR EACH ROW EXECUTE FUNCTION public.update_updated_at_column();


--
-- Name: rent_payments update_rent_payments_updated_at; Type: TRIGGER; Schema: public; Owner: -
--

CREATE TRIGGER update_rent_payments_updated_at BEFORE UPDATE ON public.rent_payments FOR EACH ROW EXECUTE FUNCTION public.update_updated_at_column();


--
-- Name: tenancies update_tenancies_updated_at; Type: TRIGGER; Schema: public; Owner: -
--

CREATE TRIGGER update_tenancies_updated_at BEFORE UPDATE ON public.tenancies FOR EACH ROW EXECUTE FUNCTION public.update_updated_at_column();


--
-- Name: activities activities_contact_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.activities
    ADD CONSTRAINT activities_contact_id_fkey FOREIGN KEY (contact_id) REFERENCES public.contacts(id) ON DELETE CASCADE;


--
-- Name: activities activities_property_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.activities
    ADD CONSTRAINT activities_property_id_fkey FOREIGN KEY (property_id) REFERENCES public.properties(id) ON DELETE CASCADE;


--
-- Name: activities activities_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.activities
    ADD CONSTRAINT activities_user_id_fkey FOREIGN KEY (user_id) REFERENCES auth.users(id) ON DELETE CASCADE;


--
-- Name: attachments attachments_contact_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.attachments
    ADD CONSTRAINT attachments_contact_id_fkey FOREIGN KEY (contact_id) REFERENCES public.contacts(id) ON DELETE CASCADE;


--
-- Name: attachments attachments_property_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.attachments
    ADD CONSTRAINT attachments_property_id_fkey FOREIGN KEY (property_id) REFERENCES public.properties(id) ON DELETE CASCADE;


--
-- Name: attachments attachments_tenancy_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.attachments
    ADD CONSTRAINT attachments_tenancy_id_fkey FOREIGN KEY (tenancy_id) REFERENCES public.tenancies(id) ON DELETE CASCADE;


--
-- Name: business_email_config business_email_config_business_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.business_email_config
    ADD CONSTRAINT business_email_config_business_id_fkey FOREIGN KEY (business_id) REFERENCES public.business(id) ON DELETE CASCADE;


--
-- Name: contact_custom_values contact_custom_values_contact_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.contact_custom_values
    ADD CONSTRAINT contact_custom_values_contact_id_fkey FOREIGN KEY (contact_id) REFERENCES public.contacts(id) ON DELETE CASCADE;


--
-- Name: contact_custom_values contact_custom_values_custom_field_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.contact_custom_values
    ADD CONSTRAINT contact_custom_values_custom_field_id_fkey FOREIGN KEY (custom_field_id) REFERENCES public.custom_fields(id) ON DELETE CASCADE;


--
-- Name: contact_tags contact_tags_contact_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.contact_tags
    ADD CONSTRAINT contact_tags_contact_id_fkey FOREIGN KEY (contact_id) REFERENCES public.contacts(id) ON DELETE CASCADE;


--
-- Name: contact_tags contact_tags_tag_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.contact_tags
    ADD CONSTRAINT contact_tags_tag_id_fkey FOREIGN KEY (tag_id) REFERENCES public.tags(id) ON DELETE CASCADE;


--
-- Name: contacts contacts_owner_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.contacts
    ADD CONSTRAINT contacts_owner_id_fkey FOREIGN KEY (owner_id) REFERENCES auth.users(id) ON DELETE SET NULL;


--
-- Name: contacts contacts_pipeline_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.contacts
    ADD CONSTRAINT contacts_pipeline_id_fkey FOREIGN KEY (pipeline_id) REFERENCES public.pipelines(id) ON DELETE SET NULL;


--
-- Name: contacts contacts_stage_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.contacts
    ADD CONSTRAINT contacts_stage_id_fkey FOREIGN KEY (stage_id) REFERENCES public.pipeline_stages(id) ON DELETE SET NULL;


--
-- Name: notes notes_author_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.notes
    ADD CONSTRAINT notes_author_id_fkey FOREIGN KEY (author_id) REFERENCES auth.users(id) ON DELETE CASCADE;


--
-- Name: notes notes_contact_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.notes
    ADD CONSTRAINT notes_contact_id_fkey FOREIGN KEY (contact_id) REFERENCES public.contacts(id) ON DELETE CASCADE;


--
-- Name: pipeline_stages pipeline_stages_pipeline_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.pipeline_stages
    ADD CONSTRAINT pipeline_stages_pipeline_id_fkey FOREIGN KEY (pipeline_id) REFERENCES public.pipelines(id) ON DELETE CASCADE;


--
-- Name: profiles profiles_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.profiles
    ADD CONSTRAINT profiles_id_fkey FOREIGN KEY (id) REFERENCES auth.users(id) ON DELETE CASCADE;


--
-- Name: properties properties_landlord_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.properties
    ADD CONSTRAINT properties_landlord_id_fkey FOREIGN KEY (landlord_id) REFERENCES public.contacts(id);


--
-- Name: property_notes property_notes_property_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.property_notes
    ADD CONSTRAINT property_notes_property_id_fkey FOREIGN KEY (property_id) REFERENCES public.properties(id) ON DELETE CASCADE;


--
-- Name: rent_payments rent_payments_tenancy_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.rent_payments
    ADD CONSTRAINT rent_payments_tenancy_id_fkey FOREIGN KEY (tenancy_id) REFERENCES public.tenancies(id) ON DELETE CASCADE;


--
-- Name: tasks tasks_contact_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.tasks
    ADD CONSTRAINT tasks_contact_id_fkey FOREIGN KEY (contact_id) REFERENCES public.contacts(id) ON DELETE CASCADE;


--
-- Name: tasks tasks_owner_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.tasks
    ADD CONSTRAINT tasks_owner_id_fkey FOREIGN KEY (owner_id) REFERENCES auth.users(id) ON DELETE CASCADE;


--
-- Name: tenancies tenancies_property_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.tenancies
    ADD CONSTRAINT tenancies_property_id_fkey FOREIGN KEY (property_id) REFERENCES public.properties(id);


--
-- Name: tenancies tenancies_tenant_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.tenancies
    ADD CONSTRAINT tenancies_tenant_id_fkey FOREIGN KEY (tenant_id) REFERENCES public.contacts(id);


--
-- Name: user_roles user_roles_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.user_roles
    ADD CONSTRAINT user_roles_user_id_fkey FOREIGN KEY (user_id) REFERENCES auth.users(id) ON DELETE CASCADE;


--
-- Name: user_roles Admins can manage roles; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Admins can manage roles" ON public.user_roles TO authenticated USING (public.has_role(auth.uid(), 'admin'::public.app_role));


--
-- Name: activities Authenticated users can create activities; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can create activities" ON public.activities FOR INSERT TO authenticated WITH CHECK ((auth.uid() = user_id));


--
-- Name: attachments Authenticated users can create attachments; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can create attachments" ON public.attachments FOR INSERT WITH CHECK ((auth.uid() = uploaded_by));


--
-- Name: business Authenticated users can create business; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can create business" ON public.business FOR INSERT WITH CHECK (true);


--
-- Name: contact_custom_values Authenticated users can create contact_custom_values; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can create contact_custom_values" ON public.contact_custom_values FOR INSERT TO authenticated WITH CHECK (true);


--
-- Name: contact_tags Authenticated users can create contact_tags; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can create contact_tags" ON public.contact_tags FOR INSERT TO authenticated WITH CHECK (true);


--
-- Name: contacts Authenticated users can create contacts; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can create contacts" ON public.contacts FOR INSERT TO authenticated WITH CHECK (true);


--
-- Name: custom_fields Authenticated users can create custom_fields; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can create custom_fields" ON public.custom_fields FOR INSERT TO authenticated WITH CHECK (true);


--
-- Name: business_email_config Authenticated users can create email config; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can create email config" ON public.business_email_config FOR INSERT WITH CHECK (true);


--
-- Name: email_templates Authenticated users can create email_templates; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can create email_templates" ON public.email_templates FOR INSERT WITH CHECK (true);


--
-- Name: notes Authenticated users can create notes; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can create notes" ON public.notes FOR INSERT TO authenticated WITH CHECK ((auth.uid() = author_id));


--
-- Name: pipelines Authenticated users can create pipelines; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can create pipelines" ON public.pipelines FOR INSERT TO authenticated WITH CHECK (true);


--
-- Name: properties Authenticated users can create properties; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can create properties" ON public.properties FOR INSERT WITH CHECK (true);


--
-- Name: property_notes Authenticated users can create property notes; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can create property notes" ON public.property_notes FOR INSERT WITH CHECK ((auth.uid() = author_id));


--
-- Name: rent_payments Authenticated users can create rent payments; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can create rent payments" ON public.rent_payments FOR INSERT WITH CHECK (true);


--
-- Name: pipeline_stages Authenticated users can create stages; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can create stages" ON public.pipeline_stages FOR INSERT TO authenticated WITH CHECK (true);


--
-- Name: tags Authenticated users can create tags; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can create tags" ON public.tags FOR INSERT TO authenticated WITH CHECK (true);


--
-- Name: tasks Authenticated users can create tasks; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can create tasks" ON public.tasks FOR INSERT TO authenticated WITH CHECK ((auth.uid() = owner_id));


--
-- Name: tenancies Authenticated users can create tenancies; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can create tenancies" ON public.tenancies FOR INSERT WITH CHECK (true);


--
-- Name: attachments Authenticated users can delete attachments; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can delete attachments" ON public.attachments FOR DELETE USING (true);


--
-- Name: business Authenticated users can delete business; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can delete business" ON public.business FOR DELETE USING (true);


--
-- Name: contact_custom_values Authenticated users can delete contact_custom_values; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can delete contact_custom_values" ON public.contact_custom_values FOR DELETE TO authenticated USING (true);


--
-- Name: contact_tags Authenticated users can delete contact_tags; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can delete contact_tags" ON public.contact_tags FOR DELETE TO authenticated USING (true);


--
-- Name: contacts Authenticated users can delete contacts; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can delete contacts" ON public.contacts FOR DELETE TO authenticated USING (true);


--
-- Name: custom_fields Authenticated users can delete custom_fields; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can delete custom_fields" ON public.custom_fields FOR DELETE TO authenticated USING (true);


--
-- Name: business_email_config Authenticated users can delete email config; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can delete email config" ON public.business_email_config FOR DELETE USING (true);


--
-- Name: email_templates Authenticated users can delete email_templates; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can delete email_templates" ON public.email_templates FOR DELETE USING (true);


--
-- Name: notes Authenticated users can delete notes; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can delete notes" ON public.notes FOR DELETE TO authenticated USING ((auth.uid() = author_id));


--
-- Name: pipelines Authenticated users can delete pipelines; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can delete pipelines" ON public.pipelines FOR DELETE TO authenticated USING (true);


--
-- Name: properties Authenticated users can delete properties; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can delete properties" ON public.properties FOR DELETE USING (true);


--
-- Name: rent_payments Authenticated users can delete rent payments; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can delete rent payments" ON public.rent_payments FOR DELETE USING (true);


--
-- Name: pipeline_stages Authenticated users can delete stages; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can delete stages" ON public.pipeline_stages FOR DELETE TO authenticated USING (true);


--
-- Name: tags Authenticated users can delete tags; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can delete tags" ON public.tags FOR DELETE TO authenticated USING (true);


--
-- Name: tasks Authenticated users can delete tasks; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can delete tasks" ON public.tasks FOR DELETE TO authenticated USING ((auth.uid() = owner_id));


--
-- Name: tenancies Authenticated users can delete tenancies; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can delete tenancies" ON public.tenancies FOR DELETE USING (true);


--
-- Name: attachments Authenticated users can update attachments; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can update attachments" ON public.attachments FOR UPDATE USING (true);


--
-- Name: business Authenticated users can update business; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can update business" ON public.business FOR UPDATE USING (true);


--
-- Name: contact_custom_values Authenticated users can update contact_custom_values; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can update contact_custom_values" ON public.contact_custom_values FOR UPDATE TO authenticated USING (true);


--
-- Name: contacts Authenticated users can update contacts; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can update contacts" ON public.contacts FOR UPDATE TO authenticated USING (true);


--
-- Name: custom_fields Authenticated users can update custom_fields; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can update custom_fields" ON public.custom_fields FOR UPDATE TO authenticated USING (true);


--
-- Name: business_email_config Authenticated users can update email config; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can update email config" ON public.business_email_config FOR UPDATE USING (true);


--
-- Name: email_templates Authenticated users can update email_templates; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can update email_templates" ON public.email_templates FOR UPDATE USING (true);


--
-- Name: notes Authenticated users can update notes; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can update notes" ON public.notes FOR UPDATE TO authenticated USING ((auth.uid() = author_id));


--
-- Name: pipelines Authenticated users can update pipelines; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can update pipelines" ON public.pipelines FOR UPDATE TO authenticated USING (true);


--
-- Name: properties Authenticated users can update properties; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can update properties" ON public.properties FOR UPDATE USING (true);


--
-- Name: rent_payments Authenticated users can update rent payments; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can update rent payments" ON public.rent_payments FOR UPDATE USING (true);


--
-- Name: pipeline_stages Authenticated users can update stages; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can update stages" ON public.pipeline_stages FOR UPDATE TO authenticated USING (true);


--
-- Name: tags Authenticated users can update tags; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can update tags" ON public.tags FOR UPDATE TO authenticated USING (true);


--
-- Name: tasks Authenticated users can update tasks; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can update tasks" ON public.tasks FOR UPDATE TO authenticated USING (true);


--
-- Name: tenancies Authenticated users can update tenancies; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can update tenancies" ON public.tenancies FOR UPDATE USING (true);


--
-- Name: activities Authenticated users can view activities; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can view activities" ON public.activities FOR SELECT TO authenticated USING (true);


--
-- Name: attachments Authenticated users can view attachments; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can view attachments" ON public.attachments FOR SELECT USING (true);


--
-- Name: business Authenticated users can view business; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can view business" ON public.business FOR SELECT USING (true);


--
-- Name: contact_custom_values Authenticated users can view contact_custom_values; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can view contact_custom_values" ON public.contact_custom_values FOR SELECT TO authenticated USING (true);


--
-- Name: contact_tags Authenticated users can view contact_tags; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can view contact_tags" ON public.contact_tags FOR SELECT TO authenticated USING (true);


--
-- Name: contacts Authenticated users can view contacts; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can view contacts" ON public.contacts FOR SELECT TO authenticated USING (true);


--
-- Name: custom_fields Authenticated users can view custom_fields; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can view custom_fields" ON public.custom_fields FOR SELECT TO authenticated USING (true);


--
-- Name: business_email_config Authenticated users can view email config; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can view email config" ON public.business_email_config FOR SELECT USING (true);


--
-- Name: email_templates Authenticated users can view email_templates; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can view email_templates" ON public.email_templates FOR SELECT USING (true);


--
-- Name: notes Authenticated users can view notes; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can view notes" ON public.notes FOR SELECT TO authenticated USING (true);


--
-- Name: pipelines Authenticated users can view pipelines; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can view pipelines" ON public.pipelines FOR SELECT TO authenticated USING (true);


--
-- Name: properties Authenticated users can view properties; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can view properties" ON public.properties FOR SELECT USING (true);


--
-- Name: property_notes Authenticated users can view property notes; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can view property notes" ON public.property_notes FOR SELECT USING (true);


--
-- Name: rent_payments Authenticated users can view rent payments; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can view rent payments" ON public.rent_payments FOR SELECT USING (true);


--
-- Name: pipeline_stages Authenticated users can view stages; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can view stages" ON public.pipeline_stages FOR SELECT TO authenticated USING (true);


--
-- Name: tags Authenticated users can view tags; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can view tags" ON public.tags FOR SELECT TO authenticated USING (true);


--
-- Name: tasks Authenticated users can view tasks; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can view tasks" ON public.tasks FOR SELECT TO authenticated USING (true);


--
-- Name: tenancies Authenticated users can view tenancies; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Authenticated users can view tenancies" ON public.tenancies FOR SELECT USING (true);


--
-- Name: property_notes Users can delete own property notes; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Users can delete own property notes" ON public.property_notes FOR DELETE USING ((auth.uid() = author_id));


--
-- Name: profiles Users can update own profile; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Users can update own profile" ON public.profiles FOR UPDATE TO authenticated USING ((auth.uid() = id));


--
-- Name: property_notes Users can update own property notes; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Users can update own property notes" ON public.property_notes FOR UPDATE USING ((auth.uid() = author_id));


--
-- Name: profiles Users can view all profiles; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Users can view all profiles" ON public.profiles FOR SELECT TO authenticated USING (true);


--
-- Name: user_roles Users can view own roles; Type: POLICY; Schema: public; Owner: -
--

CREATE POLICY "Users can view own roles" ON public.user_roles FOR SELECT TO authenticated USING ((auth.uid() = user_id));


--
-- Name: activities; Type: ROW SECURITY; Schema: public; Owner: -
--

ALTER TABLE public.activities ENABLE ROW LEVEL SECURITY;

--
-- Name: attachments; Type: ROW SECURITY; Schema: public; Owner: -
--

ALTER TABLE public.attachments ENABLE ROW LEVEL SECURITY;

--
-- Name: business; Type: ROW SECURITY; Schema: public; Owner: -
--

ALTER TABLE public.business ENABLE ROW LEVEL SECURITY;

--
-- Name: business_email_config; Type: ROW SECURITY; Schema: public; Owner: -
--

ALTER TABLE public.business_email_config ENABLE ROW LEVEL SECURITY;

--
-- Name: contact_custom_values; Type: ROW SECURITY; Schema: public; Owner: -
--

ALTER TABLE public.contact_custom_values ENABLE ROW LEVEL SECURITY;

--
-- Name: contact_tags; Type: ROW SECURITY; Schema: public; Owner: -
--

ALTER TABLE public.contact_tags ENABLE ROW LEVEL SECURITY;

--
-- Name: contacts; Type: ROW SECURITY; Schema: public; Owner: -
--

ALTER TABLE public.contacts ENABLE ROW LEVEL SECURITY;

--
-- Name: custom_fields; Type: ROW SECURITY; Schema: public; Owner: -
--

ALTER TABLE public.custom_fields ENABLE ROW LEVEL SECURITY;

--
-- Name: email_templates; Type: ROW SECURITY; Schema: public; Owner: -
--

ALTER TABLE public.email_templates ENABLE ROW LEVEL SECURITY;

--
-- Name: notes; Type: ROW SECURITY; Schema: public; Owner: -
--

ALTER TABLE public.notes ENABLE ROW LEVEL SECURITY;

--
-- Name: pipeline_stages; Type: ROW SECURITY; Schema: public; Owner: -
--

ALTER TABLE public.pipeline_stages ENABLE ROW LEVEL SECURITY;

--
-- Name: pipelines; Type: ROW SECURITY; Schema: public; Owner: -
--

ALTER TABLE public.pipelines ENABLE ROW LEVEL SECURITY;

--
-- Name: profiles; Type: ROW SECURITY; Schema: public; Owner: -
--

ALTER TABLE public.profiles ENABLE ROW LEVEL SECURITY;

--
-- Name: properties; Type: ROW SECURITY; Schema: public; Owner: -
--

ALTER TABLE public.properties ENABLE ROW LEVEL SECURITY;

--
-- Name: property_notes; Type: ROW SECURITY; Schema: public; Owner: -
--

ALTER TABLE public.property_notes ENABLE ROW LEVEL SECURITY;

--
-- Name: rent_payments; Type: ROW SECURITY; Schema: public; Owner: -
--

ALTER TABLE public.rent_payments ENABLE ROW LEVEL SECURITY;

--
-- Name: tags; Type: ROW SECURITY; Schema: public; Owner: -
--

ALTER TABLE public.tags ENABLE ROW LEVEL SECURITY;

--
-- Name: tasks; Type: ROW SECURITY; Schema: public; Owner: -
--

ALTER TABLE public.tasks ENABLE ROW LEVEL SECURITY;

--
-- Name: tenancies; Type: ROW SECURITY; Schema: public; Owner: -
--

ALTER TABLE public.tenancies ENABLE ROW LEVEL SECURITY;

--
-- Name: user_roles; Type: ROW SECURITY; Schema: public; Owner: -
--

ALTER TABLE public.user_roles ENABLE ROW LEVEL SECURITY;

--
-- PostgreSQL database dump complete
--




COMMIT;