import { Users, TrendingUp, Target, DollarSign } from 'lucide-react';
import { StatsCard } from '@/components/dashboard/StatsCard';
import { TasksList } from '@/components/dashboard/TasksList';
import { RecentContacts } from '@/components/dashboard/RecentContacts';
import { mockContacts, mockTasks } from '@/lib/mock-data';
export default function Dashboard() {
  return <div className="p-6 space-y-6 animate-fade-in">
      <div>
        <h1 className="text-2xl font-bold tracking-tight">Dashboard</h1>
        <p className="text-muted-foreground mt-1">Welcome back! Here's what's happening with your Property Agency CRM.</p>
      </div>

      <div className="grid gap-4 md:grid-cols-2 lg:grid-cols-4">
        <StatsCard title="Total Contacts" value="1,284" change="+12% from last month" changeType="positive" icon={Users} delay={0} />
        <StatsCard title="New Leads" value="48" change="+8 this week" changeType="positive" icon={TrendingUp} delay={0.1} />
        <StatsCard title="Conversion Rate" value="24.5%" change="-2.1% from last month" changeType="negative" icon={Target} delay={0.2} />
        <StatsCard title="Pipeline Value" value="$124.5K" change="+$23K this month" changeType="positive" icon={DollarSign} delay={0.3} />
      </div>

      <div className="grid gap-6 lg:grid-cols-2">
        <TasksList tasks={mockTasks} />
        <RecentContacts contacts={mockContacts} />
      </div>
    </div>;
}