// CRM Core Types

export type UserRole = 'admin' | 'manager' | 'user';

export interface User {
  id: string;
  email: string;
  name: string;
  avatar?: string;
  role: UserRole;
  createdAt: Date;
}

export type ContactStatus = 'lead' | 'prospect' | 'customer' | 'churned';

export interface Contact {
  id: string;
  firstName: string;
  lastName: string;
  email: string;
  phone?: string;
  company?: string;
  status: ContactStatus;
  ownerId?: string;
  pipelineId?: string;
  stageId?: string;
  source?: string;
  tags: Tag[];
  createdAt: Date;
  updatedAt: Date;
}

export interface Tag {
  id: string;
  name: string;
  color: string;
  description?: string;
  contactCount?: number;
}

export interface Pipeline {
  id: string;
  name: string;
  description?: string;
  isDefault: boolean;
  stages: PipelineStage[];
}

export interface PipelineStage {
  id: string;
  pipelineId: string;
  name: string;
  order: number;
  probability?: number;
  color?: string;
}

export interface Task {
  id: string;
  contactId?: string;
  ownerId: string;
  title: string;
  description?: string;
  dueDate?: Date;
  completedAt?: Date;
  status: 'pending' | 'completed' | 'overdue';
  priority: 'low' | 'medium' | 'high';
  type: 'call' | 'email' | 'meeting' | 'follow-up' | 'other';
}

export interface Note {
  id: string;
  contactId: string;
  authorId: string;
  content: string;
  createdAt: Date;
  updatedAt: Date;
}

export interface Activity {
  id: string;
  contactId: string;
  userId: string;
  type: 'email' | 'sms' | 'call' | 'system';
  direction: 'inbound' | 'outbound' | 'log';
  subject?: string;
  bodyPreview?: string;
  status: 'sent' | 'failed' | 'logged';
  createdAt: Date;
}

export interface Segment {
  id: string;
  name: string;
  description?: string;
  filterJson: string;
  contactCount?: number;
}

export interface CustomField {
  id: string;
  entityType: 'contact';
  name: string;
  label: string;
  fieldType: 'text' | 'number' | 'date' | 'boolean' | 'select';
  options?: string[];
  isRequired: boolean;
  isActive: boolean;
  sortOrder: number;
}

export interface MenuItem {
  id: string;
  label: string;
  path: string;
  icon: string;
  children?: MenuItem[];
  requiredRoles?: UserRole[];
  badge?: string;
}

export interface ThemePreferences {
  mode: 'light' | 'dark' | 'system';
  accentColor: string;
  layoutMode: 'sidebar' | 'topbar';
  density: 'comfortable' | 'compact';
}
