import { Contact, Tag, Pipeline, Task, Activity, MenuItem, Note, CustomField } from './types';

export const mockTags: Tag[] = [
  { id: '1', name: 'VIP', color: '#8B5CF6', contactCount: 12 },
  { id: '2', name: 'Hot Lead', color: '#F59E0B', contactCount: 28 },
  { id: '3', name: 'Enterprise', color: '#3B82F6', contactCount: 8 },
  { id: '4', name: 'Churned', color: '#EF4444', contactCount: 5 },
  { id: '5', name: 'Partner', color: '#10B981', contactCount: 15 },
];

export const mockContacts: Contact[] = [
  {
    id: '1',
    firstName: 'Sarah',
    lastName: 'Johnson',
    email: 'sarah.johnson@acme.com',
    phone: '+1 (555) 123-4567',
    company: 'Acme Corp',
    status: 'customer',
    stageId: 's4',
    tags: [mockTags[0], mockTags[2]],
    source: 'Referral',
    createdAt: new Date('2024-01-15'),
    updatedAt: new Date('2024-12-28'),
  },
  {
    id: '2',
    firstName: 'Michael',
    lastName: 'Chen',
    email: 'mchen@techstart.io',
    phone: '+1 (555) 234-5678',
    company: 'TechStart',
    status: 'prospect',
    stageId: 's2',
    tags: [mockTags[1]],
    source: 'Website',
    createdAt: new Date('2024-11-20'),
    updatedAt: new Date('2024-12-27'),
  },
  {
    id: '3',
    firstName: 'Emily',
    lastName: 'Rodriguez',
    email: 'emily@globalinc.com',
    phone: '+1 (555) 345-6789',
    company: 'Global Inc',
    status: 'lead',
    stageId: 's1',
    tags: [mockTags[2]],
    source: 'LinkedIn',
    createdAt: new Date('2024-12-10'),
    updatedAt: new Date('2024-12-26'),
  },
  {
    id: '4',
    firstName: 'David',
    lastName: 'Kim',
    email: 'david.kim@startup.co',
    company: 'Startup Co',
    status: 'prospect',
    stageId: 's3',
    tags: [mockTags[1], mockTags[4]],
    source: 'Conference',
    createdAt: new Date('2024-10-05'),
    updatedAt: new Date('2024-12-25'),
  },
  {
    id: '5',
    firstName: 'Lisa',
    lastName: 'Wang',
    email: 'lwang@enterprise.net',
    phone: '+1 (555) 456-7890',
    company: 'Enterprise Net',
    status: 'customer',
    stageId: 's4',
    tags: [mockTags[0], mockTags[2], mockTags[4]],
    source: 'Referral',
    createdAt: new Date('2024-06-20'),
    updatedAt: new Date('2024-12-24'),
  },
];

export const mockPipelines: Pipeline[] = [
  {
    id: 'p1',
    name: 'Sales Pipeline',
    description: 'Main sales process',
    isDefault: true,
    stages: [
      { id: 's1', pipelineId: 'p1', name: 'New Lead', order: 0, probability: 10, color: '#64748B' },
      { id: 's2', pipelineId: 'p1', name: 'Contacted', order: 1, probability: 25, color: '#3B82F6' },
      { id: 's3', pipelineId: 'p1', name: 'Proposal Sent', order: 2, probability: 50, color: '#8B5CF6' },
      { id: 's4', pipelineId: 'p1', name: 'Negotiation', order: 3, probability: 75, color: '#F59E0B' },
      { id: 's5', pipelineId: 'p1', name: 'Closed Won', order: 4, probability: 100, color: '#10B981' },
    ],
  },
];

export const mockTasks: Task[] = [
  {
    id: 't1',
    contactId: '1',
    ownerId: 'u1',
    title: 'Follow up on proposal',
    description: 'Discuss the enterprise package pricing',
    dueDate: new Date('2024-12-31'),
    status: 'pending',
    priority: 'high',
    type: 'call',
  },
  {
    id: 't2',
    contactId: '2',
    ownerId: 'u1',
    title: 'Send product demo',
    dueDate: new Date('2025-01-02'),
    status: 'pending',
    priority: 'medium',
    type: 'email',
  },
  {
    id: 't3',
    contactId: '3',
    ownerId: 'u1',
    title: 'Initial discovery call',
    dueDate: new Date('2024-12-30'),
    status: 'pending',
    priority: 'high',
    type: 'meeting',
  },
  {
    id: 't4',
    ownerId: 'u1',
    title: 'Prepare Q1 report',
    dueDate: new Date('2025-01-05'),
    status: 'pending',
    priority: 'low',
    type: 'other',
  },
];

export const mockActivities: Activity[] = [
  {
    id: 'a1',
    contactId: '1',
    userId: 'u1',
    type: 'email',
    direction: 'outbound',
    subject: 'Enterprise Package Proposal',
    bodyPreview: 'Hi Sarah, Please find attached the enterprise pricing...',
    status: 'sent',
    createdAt: new Date('2024-12-28T10:30:00'),
  },
  {
    id: 'a2',
    contactId: '1',
    userId: 'u1',
    type: 'call',
    direction: 'outbound',
    subject: 'Follow-up Call',
    bodyPreview: 'Discussed contract terms and next steps...',
    status: 'logged',
    createdAt: new Date('2024-12-26T15:00:00'),
  },
  {
    id: 'a3',
    contactId: '2',
    userId: 'u1',
    type: 'call',
    direction: 'outbound',
    subject: 'Initial Discovery Call',
    bodyPreview: 'Discussed requirements and timeline...',
    status: 'logged',
    createdAt: new Date('2024-12-27T14:00:00'),
  },
  {
    id: 'a4',
    contactId: '1',
    userId: 'u1',
    type: 'sms',
    direction: 'outbound',
    subject: 'Meeting Reminder',
    bodyPreview: 'Quick reminder about our call tomorrow at 2pm',
    status: 'sent',
    createdAt: new Date('2024-12-25T09:00:00'),
  },
];

export const mockNotes: Note[] = [
  {
    id: 'n1',
    contactId: '1',
    authorId: 'u1',
    content: 'Sarah mentioned they are looking to expand their team by Q2. Great opportunity for upselling the enterprise plan.',
    createdAt: new Date('2024-12-28T11:00:00'),
    updatedAt: new Date('2024-12-28T11:00:00'),
  },
  {
    id: 'n2',
    contactId: '1',
    authorId: 'u1',
    content: 'Budget approved for the project. Decision maker is the CTO.',
    createdAt: new Date('2024-12-20T14:30:00'),
    updatedAt: new Date('2024-12-20T14:30:00'),
  },
  {
    id: 'n3',
    contactId: '2',
    authorId: 'u1',
    content: 'Interested in the starter plan initially but may upgrade after POC.',
    createdAt: new Date('2024-12-27T15:00:00'),
    updatedAt: new Date('2024-12-27T15:00:00'),
  },
];

export const mockCustomFields: CustomField[] = [
  {
    id: 'cf1',
    entityType: 'contact',
    name: 'industry',
    label: 'Industry',
    fieldType: 'select',
    options: ['Technology', 'Finance', 'Healthcare', 'Retail', 'Manufacturing'],
    isRequired: false,
    isActive: true,
    sortOrder: 1,
  },
  {
    id: 'cf2',
    entityType: 'contact',
    name: 'annual_revenue',
    label: 'Annual Revenue',
    fieldType: 'text',
    isRequired: false,
    isActive: true,
    sortOrder: 2,
  },
  {
    id: 'cf3',
    entityType: 'contact',
    name: 'employee_count',
    label: 'Employee Count',
    fieldType: 'number',
    isRequired: false,
    isActive: true,
    sortOrder: 3,
  },
  {
    id: 'cf4',
    entityType: 'contact',
    name: 'contract_start',
    label: 'Contract Start Date',
    fieldType: 'date',
    isRequired: false,
    isActive: true,
    sortOrder: 4,
  },
  {
    id: 'cf5',
    entityType: 'contact',
    name: 'is_partner',
    label: 'Partner Account',
    fieldType: 'boolean',
    isRequired: false,
    isActive: true,
    sortOrder: 5,
  },
];

export const mockCustomFieldValues: Record<string, Record<string, string>> = {
  '1': {
    industry: 'Technology',
    annual_revenue: '$5M - $10M',
    employee_count: '150',
    contract_start: '2024-01-15',
    is_partner: 'true',
  },
  '2': {
    industry: 'Technology',
    annual_revenue: '$1M - $5M',
    employee_count: '45',
  },
  '5': {
    industry: 'Finance',
    annual_revenue: '$50M+',
    employee_count: '500',
    is_partner: 'true',
  },
};

export interface Attachment {
  id: string;
  contactId: string;
  fileName: string;
  fileSize: number;
  mimeType: string;
  uploadedBy: string;
  createdAt: Date;
}

export const mockAttachments: Attachment[] = [
  {
    id: 'att1',
    contactId: '1',
    fileName: 'Proposal_v2.pdf',
    fileSize: 2456000,
    mimeType: 'application/pdf',
    uploadedBy: 'u1',
    createdAt: new Date('2024-12-28T10:00:00'),
  },
  {
    id: 'att2',
    contactId: '1',
    fileName: 'Contract_Draft.docx',
    fileSize: 145000,
    mimeType: 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
    uploadedBy: 'u1',
    createdAt: new Date('2024-12-26T14:00:00'),
  },
  {
    id: 'att3',
    contactId: '1',
    fileName: 'Requirements.xlsx',
    fileSize: 89000,
    mimeType: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
    uploadedBy: 'u1',
    createdAt: new Date('2024-12-20T11:00:00'),
  },
];

export const menuItems: MenuItem[] = [
  { id: 'dashboard', label: 'Dashboard', path: '/', icon: 'LayoutDashboard' },
  { id: 'contacts', label: 'Contacts', path: '/contacts', icon: 'Users' },
  { id: 'pipelines', label: 'Pipelines', path: '/pipelines', icon: 'Kanban' },
  { id: 'tasks', label: 'Tasks', path: '/tasks', icon: 'CheckSquare', badge: '4' },
  { id: 'tags', label: 'Tags', path: '/tags', icon: 'Tag' },
  { id: 'segments', label: 'Segments', path: '/segments', icon: 'Filter' },
  { id: 'import', label: 'Import/Export', path: '/import', icon: 'Upload' },
  { 
    id: 'settings', 
    label: 'Settings', 
    path: '/settings', 
    icon: 'Settings',
    children: [
      { id: 'appearance', label: 'Appearance', path: '/settings/appearance', icon: 'Palette' },
      { id: 'account', label: 'Account', path: '/settings/account', icon: 'User' },
      { id: 'custom-fields', label: 'Custom Fields', path: '/settings/custom-fields', icon: 'FormInput' },
      { id: 'audit-logs', label: 'Audit Logs', path: '/settings/audit-logs', icon: 'ScrollText', requiredRoles: ['admin'] },
    ],
  },
];
