export type Json =
  | string
  | number
  | boolean
  | null
  | { [key: string]: Json | undefined }
  | Json[]

export type Database = {
  // Allows to automatically instantiate createClient with right options
  // instead of createClient<Database, { PostgrestVersion: 'XX' }>(URL, KEY)
  __InternalSupabase: {
    PostgrestVersion: "14.1"
  }
  public: {
    Tables: {
      activities: {
        Row: {
          body_preview: string | null
          category: string
          contact_id: string | null
          created_at: string
          direction: Database["public"]["Enums"]["activity_direction"]
          id: string
          property_id: string | null
          status: string
          subject: string | null
          type: Database["public"]["Enums"]["activity_type"]
          user_id: string
        }
        Insert: {
          body_preview?: string | null
          category?: string
          contact_id?: string | null
          created_at?: string
          direction?: Database["public"]["Enums"]["activity_direction"]
          id?: string
          property_id?: string | null
          status?: string
          subject?: string | null
          type: Database["public"]["Enums"]["activity_type"]
          user_id: string
        }
        Update: {
          body_preview?: string | null
          category?: string
          contact_id?: string | null
          created_at?: string
          direction?: Database["public"]["Enums"]["activity_direction"]
          id?: string
          property_id?: string | null
          status?: string
          subject?: string | null
          type?: Database["public"]["Enums"]["activity_type"]
          user_id?: string
        }
        Relationships: [
          {
            foreignKeyName: "activities_contact_id_fkey"
            columns: ["contact_id"]
            isOneToOne: false
            referencedRelation: "contacts"
            referencedColumns: ["id"]
          },
          {
            foreignKeyName: "activities_property_id_fkey"
            columns: ["property_id"]
            isOneToOne: false
            referencedRelation: "properties"
            referencedColumns: ["id"]
          },
        ]
      }
      attachments: {
        Row: {
          category: string
          contact_id: string | null
          created_at: string
          entity_id: string | null
          entity_type: string | null
          file_name: string
          file_path: string
          file_size: number
          id: string
          mime_type: string
          property_id: string | null
          tenancy_id: string | null
          updated_at: string
          uploaded_by: string
        }
        Insert: {
          category?: string
          contact_id?: string | null
          created_at?: string
          entity_id?: string | null
          entity_type?: string | null
          file_name: string
          file_path: string
          file_size: number
          id?: string
          mime_type: string
          property_id?: string | null
          tenancy_id?: string | null
          updated_at?: string
          uploaded_by: string
        }
        Update: {
          category?: string
          contact_id?: string | null
          created_at?: string
          entity_id?: string | null
          entity_type?: string | null
          file_name?: string
          file_path?: string
          file_size?: number
          id?: string
          mime_type?: string
          property_id?: string | null
          tenancy_id?: string | null
          updated_at?: string
          uploaded_by?: string
        }
        Relationships: [
          {
            foreignKeyName: "attachments_contact_id_fkey"
            columns: ["contact_id"]
            isOneToOne: false
            referencedRelation: "contacts"
            referencedColumns: ["id"]
          },
          {
            foreignKeyName: "attachments_property_id_fkey"
            columns: ["property_id"]
            isOneToOne: false
            referencedRelation: "properties"
            referencedColumns: ["id"]
          },
          {
            foreignKeyName: "attachments_tenancy_id_fkey"
            columns: ["tenancy_id"]
            isOneToOne: false
            referencedRelation: "tenancies"
            referencedColumns: ["id"]
          },
        ]
      }
      business: {
        Row: {
          address: string | null
          city: string | null
          country: string | null
          created_at: string
          email: string | null
          id: string
          industries: string[] | null
          location: string | null
          logo_url: string | null
          name: string
          owner_email: string | null
          owner_name: string | null
          owner_phone: string | null
          phone: string | null
          postal_code: string | null
          preferred_accent_color: string | null
          preferred_layout: string | null
          preferred_theme: string | null
          state: string | null
          updated_at: string
          website: string | null
        }
        Insert: {
          address?: string | null
          city?: string | null
          country?: string | null
          created_at?: string
          email?: string | null
          id?: string
          industries?: string[] | null
          location?: string | null
          logo_url?: string | null
          name: string
          owner_email?: string | null
          owner_name?: string | null
          owner_phone?: string | null
          phone?: string | null
          postal_code?: string | null
          preferred_accent_color?: string | null
          preferred_layout?: string | null
          preferred_theme?: string | null
          state?: string | null
          updated_at?: string
          website?: string | null
        }
        Update: {
          address?: string | null
          city?: string | null
          country?: string | null
          created_at?: string
          email?: string | null
          id?: string
          industries?: string[] | null
          location?: string | null
          logo_url?: string | null
          name?: string
          owner_email?: string | null
          owner_name?: string | null
          owner_phone?: string | null
          phone?: string | null
          postal_code?: string | null
          preferred_accent_color?: string | null
          preferred_layout?: string | null
          preferred_theme?: string | null
          state?: string | null
          updated_at?: string
          website?: string | null
        }
        Relationships: []
      }
      business_email_config: {
        Row: {
          business_id: string | null
          created_at: string
          from_email: string | null
          from_name: string | null
          id: string
          is_active: boolean
          provider: string
          reply_to_email: string | null
          smtp_encryption: string | null
          smtp_host: string | null
          smtp_password: string | null
          smtp_port: number | null
          smtp_username: string | null
          updated_at: string
        }
        Insert: {
          business_id?: string | null
          created_at?: string
          from_email?: string | null
          from_name?: string | null
          id?: string
          is_active?: boolean
          provider?: string
          reply_to_email?: string | null
          smtp_encryption?: string | null
          smtp_host?: string | null
          smtp_password?: string | null
          smtp_port?: number | null
          smtp_username?: string | null
          updated_at?: string
        }
        Update: {
          business_id?: string | null
          created_at?: string
          from_email?: string | null
          from_name?: string | null
          id?: string
          is_active?: boolean
          provider?: string
          reply_to_email?: string | null
          smtp_encryption?: string | null
          smtp_host?: string | null
          smtp_password?: string | null
          smtp_port?: number | null
          smtp_username?: string | null
          updated_at?: string
        }
        Relationships: [
          {
            foreignKeyName: "business_email_config_business_id_fkey"
            columns: ["business_id"]
            isOneToOne: false
            referencedRelation: "business"
            referencedColumns: ["id"]
          },
        ]
      }
      contact_custom_values: {
        Row: {
          contact_id: string
          created_at: string
          custom_field_id: string
          id: string
          updated_at: string
          value: string | null
        }
        Insert: {
          contact_id: string
          created_at?: string
          custom_field_id: string
          id?: string
          updated_at?: string
          value?: string | null
        }
        Update: {
          contact_id?: string
          created_at?: string
          custom_field_id?: string
          id?: string
          updated_at?: string
          value?: string | null
        }
        Relationships: [
          {
            foreignKeyName: "contact_custom_values_contact_id_fkey"
            columns: ["contact_id"]
            isOneToOne: false
            referencedRelation: "contacts"
            referencedColumns: ["id"]
          },
          {
            foreignKeyName: "contact_custom_values_custom_field_id_fkey"
            columns: ["custom_field_id"]
            isOneToOne: false
            referencedRelation: "custom_fields"
            referencedColumns: ["id"]
          },
        ]
      }
      contact_tags: {
        Row: {
          contact_id: string
          created_at: string
          id: string
          tag_id: string
        }
        Insert: {
          contact_id: string
          created_at?: string
          id?: string
          tag_id: string
        }
        Update: {
          contact_id?: string
          created_at?: string
          id?: string
          tag_id?: string
        }
        Relationships: [
          {
            foreignKeyName: "contact_tags_contact_id_fkey"
            columns: ["contact_id"]
            isOneToOne: false
            referencedRelation: "contacts"
            referencedColumns: ["id"]
          },
          {
            foreignKeyName: "contact_tags_tag_id_fkey"
            columns: ["tag_id"]
            isOneToOne: false
            referencedRelation: "tags"
            referencedColumns: ["id"]
          },
        ]
      }
      contacts: {
        Row: {
          avatar_url: string | null
          company: string | null
          created_at: string
          deleted_at: string | null
          deleted_by: string | null
          deleted_from: string | null
          email: string
          first_name: string
          id: string
          last_name: string
          owner_id: string | null
          phone: string | null
          pipeline_id: string | null
          source: string | null
          stage_id: string | null
          status: Database["public"]["Enums"]["contact_status"]
          updated_at: string
        }
        Insert: {
          avatar_url?: string | null
          company?: string | null
          created_at?: string
          deleted_at?: string | null
          deleted_by?: string | null
          deleted_from?: string | null
          email: string
          first_name: string
          id?: string
          last_name: string
          owner_id?: string | null
          phone?: string | null
          pipeline_id?: string | null
          source?: string | null
          stage_id?: string | null
          status?: Database["public"]["Enums"]["contact_status"]
          updated_at?: string
        }
        Update: {
          avatar_url?: string | null
          company?: string | null
          created_at?: string
          deleted_at?: string | null
          deleted_by?: string | null
          deleted_from?: string | null
          email?: string
          first_name?: string
          id?: string
          last_name?: string
          owner_id?: string | null
          phone?: string | null
          pipeline_id?: string | null
          source?: string | null
          stage_id?: string | null
          status?: Database["public"]["Enums"]["contact_status"]
          updated_at?: string
        }
        Relationships: [
          {
            foreignKeyName: "contacts_pipeline_id_fkey"
            columns: ["pipeline_id"]
            isOneToOne: false
            referencedRelation: "pipelines"
            referencedColumns: ["id"]
          },
          {
            foreignKeyName: "contacts_stage_id_fkey"
            columns: ["stage_id"]
            isOneToOne: false
            referencedRelation: "pipeline_stages"
            referencedColumns: ["id"]
          },
        ]
      }
      custom_fields: {
        Row: {
          created_at: string
          entity_type: string
          field_type: Database["public"]["Enums"]["custom_field_type"]
          id: string
          is_active: boolean
          is_required: boolean
          label: string
          name: string
          options: Json | null
          sort_order: number
          updated_at: string
        }
        Insert: {
          created_at?: string
          entity_type?: string
          field_type?: Database["public"]["Enums"]["custom_field_type"]
          id?: string
          is_active?: boolean
          is_required?: boolean
          label: string
          name: string
          options?: Json | null
          sort_order?: number
          updated_at?: string
        }
        Update: {
          created_at?: string
          entity_type?: string
          field_type?: Database["public"]["Enums"]["custom_field_type"]
          id?: string
          is_active?: boolean
          is_required?: boolean
          label?: string
          name?: string
          options?: Json | null
          sort_order?: number
          updated_at?: string
        }
        Relationships: []
      }
      email_templates: {
        Row: {
          body: string
          created_at: string
          description: string | null
          id: string
          is_active: boolean
          name: string
          subject: string
          updated_at: string
        }
        Insert: {
          body: string
          created_at?: string
          description?: string | null
          id?: string
          is_active?: boolean
          name: string
          subject: string
          updated_at?: string
        }
        Update: {
          body?: string
          created_at?: string
          description?: string | null
          id?: string
          is_active?: boolean
          name?: string
          subject?: string
          updated_at?: string
        }
        Relationships: []
      }
      notes: {
        Row: {
          author_id: string
          contact_id: string
          content: string
          created_at: string
          id: string
          updated_at: string
        }
        Insert: {
          author_id: string
          contact_id: string
          content: string
          created_at?: string
          id?: string
          updated_at?: string
        }
        Update: {
          author_id?: string
          contact_id?: string
          content?: string
          created_at?: string
          id?: string
          updated_at?: string
        }
        Relationships: [
          {
            foreignKeyName: "notes_contact_id_fkey"
            columns: ["contact_id"]
            isOneToOne: false
            referencedRelation: "contacts"
            referencedColumns: ["id"]
          },
        ]
      }
      pipeline_stages: {
        Row: {
          color: string | null
          created_at: string
          id: string
          name: string
          order_index: number
          pipeline_id: string
          probability: number | null
          updated_at: string
        }
        Insert: {
          color?: string | null
          created_at?: string
          id?: string
          name: string
          order_index?: number
          pipeline_id: string
          probability?: number | null
          updated_at?: string
        }
        Update: {
          color?: string | null
          created_at?: string
          id?: string
          name?: string
          order_index?: number
          pipeline_id?: string
          probability?: number | null
          updated_at?: string
        }
        Relationships: [
          {
            foreignKeyName: "pipeline_stages_pipeline_id_fkey"
            columns: ["pipeline_id"]
            isOneToOne: false
            referencedRelation: "pipelines"
            referencedColumns: ["id"]
          },
        ]
      }
      pipelines: {
        Row: {
          created_at: string
          description: string | null
          id: string
          is_default: boolean
          name: string
          updated_at: string
        }
        Insert: {
          created_at?: string
          description?: string | null
          id?: string
          is_default?: boolean
          name: string
          updated_at?: string
        }
        Update: {
          created_at?: string
          description?: string | null
          id?: string
          is_default?: boolean
          name?: string
          updated_at?: string
        }
        Relationships: []
      }
      profiles: {
        Row: {
          avatar_url: string | null
          created_at: string
          email: string
          id: string
          name: string | null
          updated_at: string
        }
        Insert: {
          avatar_url?: string | null
          created_at?: string
          email: string
          id: string
          name?: string | null
          updated_at?: string
        }
        Update: {
          avatar_url?: string | null
          created_at?: string
          email?: string
          id?: string
          name?: string | null
          updated_at?: string
        }
        Relationships: []
      }
      properties: {
        Row: {
          additional_field_1: string | null
          additional_field_2: string | null
          additional_information: string | null
          address_line_1: string | null
          address_line_2: string | null
          branch: string | null
          business_category: string | null
          council_tax_band: string | null
          country: string | null
          county: string | null
          created_at: string
          dashboard_note: string | null
          date_available: string | null
          deleted_at: string | null
          deleted_by: string | null
          deposit: number | null
          display_address: string | null
          electricity_certificate_expiry: string | null
          epc_band: string | null
          epc_expiry: string | null
          epc_rating: string | null
          exclude_from_all_portals: boolean | null
          exclude_from_website: boolean | null
          exclude_from_window_rotator: boolean | null
          feature_on_homepage: boolean | null
          full_description: string | null
          gas_certificate_expiry: string | null
          ground_rent: number | null
          has_gas: boolean | null
          headline: string | null
          id: string
          insurance_expiry: string | null
          is_overseas: boolean | null
          landlord_id: string | null
          landlord_payment_frequency: string | null
          lead_staff: string | null
          legionella_risk_assessment_date: string | null
          letting_fee: number | null
          letting_service: string | null
          link_on_website: string | null
          local_authority: string | null
          maintenance_charge: number | null
          management_fee: number | null
          marketing_tag: string | null
          minimum_acceptable_price: number | null
          number_of_bathrooms: number | null
          number_of_bedrooms: number | null
          number_of_receptions: number | null
          on_the_market: boolean | null
          on_the_market_link: string | null
          pat_test_expiry: string | null
          postcode: string | null
          price: number | null
          price_qualifier: string | null
          property_class: string | null
          property_licence_expiry: string | null
          property_licence_notes: string | null
          property_licence_type: string | null
          property_type: string | null
          put_on_market: string | null
          reference: string | null
          rightmove_link: string | null
          smoke_co_alarm_expiry: string | null
          status: string | null
          summary: string | null
          town_city: string | null
          updated_at: string
          valuation_price: number | null
          viewing_arrangements: string | null
          virtual_tour_link: string | null
          virtual_tour_link_2: string | null
          zoopla_link: string | null
        }
        Insert: {
          additional_field_1?: string | null
          additional_field_2?: string | null
          additional_information?: string | null
          address_line_1?: string | null
          address_line_2?: string | null
          branch?: string | null
          business_category?: string | null
          council_tax_band?: string | null
          country?: string | null
          county?: string | null
          created_at?: string
          dashboard_note?: string | null
          date_available?: string | null
          deleted_at?: string | null
          deleted_by?: string | null
          deposit?: number | null
          display_address?: string | null
          electricity_certificate_expiry?: string | null
          epc_band?: string | null
          epc_expiry?: string | null
          epc_rating?: string | null
          exclude_from_all_portals?: boolean | null
          exclude_from_website?: boolean | null
          exclude_from_window_rotator?: boolean | null
          feature_on_homepage?: boolean | null
          full_description?: string | null
          gas_certificate_expiry?: string | null
          ground_rent?: number | null
          has_gas?: boolean | null
          headline?: string | null
          id?: string
          insurance_expiry?: string | null
          is_overseas?: boolean | null
          landlord_id?: string | null
          landlord_payment_frequency?: string | null
          lead_staff?: string | null
          legionella_risk_assessment_date?: string | null
          letting_fee?: number | null
          letting_service?: string | null
          link_on_website?: string | null
          local_authority?: string | null
          maintenance_charge?: number | null
          management_fee?: number | null
          marketing_tag?: string | null
          minimum_acceptable_price?: number | null
          number_of_bathrooms?: number | null
          number_of_bedrooms?: number | null
          number_of_receptions?: number | null
          on_the_market?: boolean | null
          on_the_market_link?: string | null
          pat_test_expiry?: string | null
          postcode?: string | null
          price?: number | null
          price_qualifier?: string | null
          property_class?: string | null
          property_licence_expiry?: string | null
          property_licence_notes?: string | null
          property_licence_type?: string | null
          property_type?: string | null
          put_on_market?: string | null
          reference?: string | null
          rightmove_link?: string | null
          smoke_co_alarm_expiry?: string | null
          status?: string | null
          summary?: string | null
          town_city?: string | null
          updated_at?: string
          valuation_price?: number | null
          viewing_arrangements?: string | null
          virtual_tour_link?: string | null
          virtual_tour_link_2?: string | null
          zoopla_link?: string | null
        }
        Update: {
          additional_field_1?: string | null
          additional_field_2?: string | null
          additional_information?: string | null
          address_line_1?: string | null
          address_line_2?: string | null
          branch?: string | null
          business_category?: string | null
          council_tax_band?: string | null
          country?: string | null
          county?: string | null
          created_at?: string
          dashboard_note?: string | null
          date_available?: string | null
          deleted_at?: string | null
          deleted_by?: string | null
          deposit?: number | null
          display_address?: string | null
          electricity_certificate_expiry?: string | null
          epc_band?: string | null
          epc_expiry?: string | null
          epc_rating?: string | null
          exclude_from_all_portals?: boolean | null
          exclude_from_website?: boolean | null
          exclude_from_window_rotator?: boolean | null
          feature_on_homepage?: boolean | null
          full_description?: string | null
          gas_certificate_expiry?: string | null
          ground_rent?: number | null
          has_gas?: boolean | null
          headline?: string | null
          id?: string
          insurance_expiry?: string | null
          is_overseas?: boolean | null
          landlord_id?: string | null
          landlord_payment_frequency?: string | null
          lead_staff?: string | null
          legionella_risk_assessment_date?: string | null
          letting_fee?: number | null
          letting_service?: string | null
          link_on_website?: string | null
          local_authority?: string | null
          maintenance_charge?: number | null
          management_fee?: number | null
          marketing_tag?: string | null
          minimum_acceptable_price?: number | null
          number_of_bathrooms?: number | null
          number_of_bedrooms?: number | null
          number_of_receptions?: number | null
          on_the_market?: boolean | null
          on_the_market_link?: string | null
          pat_test_expiry?: string | null
          postcode?: string | null
          price?: number | null
          price_qualifier?: string | null
          property_class?: string | null
          property_licence_expiry?: string | null
          property_licence_notes?: string | null
          property_licence_type?: string | null
          property_type?: string | null
          put_on_market?: string | null
          reference?: string | null
          rightmove_link?: string | null
          smoke_co_alarm_expiry?: string | null
          status?: string | null
          summary?: string | null
          town_city?: string | null
          updated_at?: string
          valuation_price?: number | null
          viewing_arrangements?: string | null
          virtual_tour_link?: string | null
          virtual_tour_link_2?: string | null
          zoopla_link?: string | null
        }
        Relationships: [
          {
            foreignKeyName: "properties_landlord_id_fkey"
            columns: ["landlord_id"]
            isOneToOne: false
            referencedRelation: "contacts"
            referencedColumns: ["id"]
          },
        ]
      }
      property_notes: {
        Row: {
          author_id: string
          content: string
          created_at: string
          id: string
          property_id: string
          updated_at: string
        }
        Insert: {
          author_id: string
          content: string
          created_at?: string
          id?: string
          property_id: string
          updated_at?: string
        }
        Update: {
          author_id?: string
          content?: string
          created_at?: string
          id?: string
          property_id?: string
          updated_at?: string
        }
        Relationships: [
          {
            foreignKeyName: "property_notes_property_id_fkey"
            columns: ["property_id"]
            isOneToOne: false
            referencedRelation: "properties"
            referencedColumns: ["id"]
          },
        ]
      }
      rent_payments: {
        Row: {
          amount: number
          created_at: string
          due_date: string
          id: string
          notes: string | null
          payment_date: string | null
          payment_method: string | null
          reference: string | null
          status: string
          tenancy_id: string
          updated_at: string
        }
        Insert: {
          amount: number
          created_at?: string
          due_date: string
          id?: string
          notes?: string | null
          payment_date?: string | null
          payment_method?: string | null
          reference?: string | null
          status?: string
          tenancy_id: string
          updated_at?: string
        }
        Update: {
          amount?: number
          created_at?: string
          due_date?: string
          id?: string
          notes?: string | null
          payment_date?: string | null
          payment_method?: string | null
          reference?: string | null
          status?: string
          tenancy_id?: string
          updated_at?: string
        }
        Relationships: [
          {
            foreignKeyName: "rent_payments_tenancy_id_fkey"
            columns: ["tenancy_id"]
            isOneToOne: false
            referencedRelation: "tenancies"
            referencedColumns: ["id"]
          },
        ]
      }
      tags: {
        Row: {
          color: string
          created_at: string
          description: string | null
          id: string
          name: string
          updated_at: string
        }
        Insert: {
          color?: string
          created_at?: string
          description?: string | null
          id?: string
          name: string
          updated_at?: string
        }
        Update: {
          color?: string
          created_at?: string
          description?: string | null
          id?: string
          name?: string
          updated_at?: string
        }
        Relationships: []
      }
      tasks: {
        Row: {
          completed_at: string | null
          contact_id: string | null
          created_at: string
          description: string | null
          due_date: string | null
          id: string
          owner_id: string
          priority: Database["public"]["Enums"]["task_priority"]
          status: Database["public"]["Enums"]["task_status"]
          title: string
          type: Database["public"]["Enums"]["task_type"]
          updated_at: string
        }
        Insert: {
          completed_at?: string | null
          contact_id?: string | null
          created_at?: string
          description?: string | null
          due_date?: string | null
          id?: string
          owner_id: string
          priority?: Database["public"]["Enums"]["task_priority"]
          status?: Database["public"]["Enums"]["task_status"]
          title: string
          type?: Database["public"]["Enums"]["task_type"]
          updated_at?: string
        }
        Update: {
          completed_at?: string | null
          contact_id?: string | null
          created_at?: string
          description?: string | null
          due_date?: string | null
          id?: string
          owner_id?: string
          priority?: Database["public"]["Enums"]["task_priority"]
          status?: Database["public"]["Enums"]["task_status"]
          title?: string
          type?: Database["public"]["Enums"]["task_type"]
          updated_at?: string
        }
        Relationships: [
          {
            foreignKeyName: "tasks_contact_id_fkey"
            columns: ["contact_id"]
            isOneToOne: false
            referencedRelation: "contacts"
            referencedColumns: ["id"]
          },
        ]
      }
      tenancies: {
        Row: {
          branch: string | null
          break_clause: string | null
          created_at: string
          deleted_at: string | null
          deleted_by: string | null
          deposit: number | null
          end_date: string | null
          id: string
          inspection_frequency: number | null
          is_hmo: boolean | null
          is_periodic: boolean | null
          is_rent_guaranteed: boolean | null
          last_inspection_date: string | null
          lead_staff: string | null
          letting_fee: number | null
          letting_service: string | null
          management_fee: number | null
          notice_period: string | null
          property_id: string | null
          reference: string | null
          renewal: string | null
          rent: number | null
          rent_payment_frequency: string | null
          rent_review_date: string | null
          start_date: string | null
          status: string | null
          tenancy_agreement_special_clause: string | null
          tenant_id: string | null
          updated_at: string
          where_deposit_held: string | null
        }
        Insert: {
          branch?: string | null
          break_clause?: string | null
          created_at?: string
          deleted_at?: string | null
          deleted_by?: string | null
          deposit?: number | null
          end_date?: string | null
          id?: string
          inspection_frequency?: number | null
          is_hmo?: boolean | null
          is_periodic?: boolean | null
          is_rent_guaranteed?: boolean | null
          last_inspection_date?: string | null
          lead_staff?: string | null
          letting_fee?: number | null
          letting_service?: string | null
          management_fee?: number | null
          notice_period?: string | null
          property_id?: string | null
          reference?: string | null
          renewal?: string | null
          rent?: number | null
          rent_payment_frequency?: string | null
          rent_review_date?: string | null
          start_date?: string | null
          status?: string | null
          tenancy_agreement_special_clause?: string | null
          tenant_id?: string | null
          updated_at?: string
          where_deposit_held?: string | null
        }
        Update: {
          branch?: string | null
          break_clause?: string | null
          created_at?: string
          deleted_at?: string | null
          deleted_by?: string | null
          deposit?: number | null
          end_date?: string | null
          id?: string
          inspection_frequency?: number | null
          is_hmo?: boolean | null
          is_periodic?: boolean | null
          is_rent_guaranteed?: boolean | null
          last_inspection_date?: string | null
          lead_staff?: string | null
          letting_fee?: number | null
          letting_service?: string | null
          management_fee?: number | null
          notice_period?: string | null
          property_id?: string | null
          reference?: string | null
          renewal?: string | null
          rent?: number | null
          rent_payment_frequency?: string | null
          rent_review_date?: string | null
          start_date?: string | null
          status?: string | null
          tenancy_agreement_special_clause?: string | null
          tenant_id?: string | null
          updated_at?: string
          where_deposit_held?: string | null
        }
        Relationships: [
          {
            foreignKeyName: "tenancies_property_id_fkey"
            columns: ["property_id"]
            isOneToOne: false
            referencedRelation: "properties"
            referencedColumns: ["id"]
          },
          {
            foreignKeyName: "tenancies_tenant_id_fkey"
            columns: ["tenant_id"]
            isOneToOne: false
            referencedRelation: "contacts"
            referencedColumns: ["id"]
          },
        ]
      }
      user_roles: {
        Row: {
          created_at: string
          id: string
          role: Database["public"]["Enums"]["app_role"]
          user_id: string
        }
        Insert: {
          created_at?: string
          id?: string
          role?: Database["public"]["Enums"]["app_role"]
          user_id: string
        }
        Update: {
          created_at?: string
          id?: string
          role?: Database["public"]["Enums"]["app_role"]
          user_id?: string
        }
        Relationships: []
      }
    }
    Views: {
      [_ in never]: never
    }
    Functions: {
      has_role: {
        Args: {
          _role: Database["public"]["Enums"]["app_role"]
          _user_id: string
        }
        Returns: boolean
      }
    }
    Enums: {
      activity_direction: "inbound" | "outbound" | "log"
      activity_type: "email" | "sms" | "call" | "system"
      app_role: "admin" | "manager" | "user"
      contact_status: "lead" | "prospect" | "customer" | "churned"
      custom_field_type: "text" | "number" | "date" | "boolean" | "select"
      task_priority: "low" | "medium" | "high"
      task_status: "pending" | "completed" | "overdue"
      task_type: "call" | "email" | "meeting" | "follow-up" | "other"
    }
    CompositeTypes: {
      [_ in never]: never
    }
  }
}

type DatabaseWithoutInternals = Omit<Database, "__InternalSupabase">

type DefaultSchema = DatabaseWithoutInternals[Extract<keyof Database, "public">]

export type Tables<
  DefaultSchemaTableNameOrOptions extends
    | keyof (DefaultSchema["Tables"] & DefaultSchema["Views"])
    | { schema: keyof DatabaseWithoutInternals },
  TableName extends DefaultSchemaTableNameOrOptions extends {
    schema: keyof DatabaseWithoutInternals
  }
    ? keyof (DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions["schema"]]["Tables"] &
        DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions["schema"]]["Views"])
    : never = never,
> = DefaultSchemaTableNameOrOptions extends {
  schema: keyof DatabaseWithoutInternals
}
  ? (DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions["schema"]]["Tables"] &
      DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions["schema"]]["Views"])[TableName] extends {
      Row: infer R
    }
    ? R
    : never
  : DefaultSchemaTableNameOrOptions extends keyof (DefaultSchema["Tables"] &
        DefaultSchema["Views"])
    ? (DefaultSchema["Tables"] &
        DefaultSchema["Views"])[DefaultSchemaTableNameOrOptions] extends {
        Row: infer R
      }
      ? R
      : never
    : never

export type TablesInsert<
  DefaultSchemaTableNameOrOptions extends
    | keyof DefaultSchema["Tables"]
    | { schema: keyof DatabaseWithoutInternals },
  TableName extends DefaultSchemaTableNameOrOptions extends {
    schema: keyof DatabaseWithoutInternals
  }
    ? keyof DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions["schema"]]["Tables"]
    : never = never,
> = DefaultSchemaTableNameOrOptions extends {
  schema: keyof DatabaseWithoutInternals
}
  ? DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions["schema"]]["Tables"][TableName] extends {
      Insert: infer I
    }
    ? I
    : never
  : DefaultSchemaTableNameOrOptions extends keyof DefaultSchema["Tables"]
    ? DefaultSchema["Tables"][DefaultSchemaTableNameOrOptions] extends {
        Insert: infer I
      }
      ? I
      : never
    : never

export type TablesUpdate<
  DefaultSchemaTableNameOrOptions extends
    | keyof DefaultSchema["Tables"]
    | { schema: keyof DatabaseWithoutInternals },
  TableName extends DefaultSchemaTableNameOrOptions extends {
    schema: keyof DatabaseWithoutInternals
  }
    ? keyof DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions["schema"]]["Tables"]
    : never = never,
> = DefaultSchemaTableNameOrOptions extends {
  schema: keyof DatabaseWithoutInternals
}
  ? DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions["schema"]]["Tables"][TableName] extends {
      Update: infer U
    }
    ? U
    : never
  : DefaultSchemaTableNameOrOptions extends keyof DefaultSchema["Tables"]
    ? DefaultSchema["Tables"][DefaultSchemaTableNameOrOptions] extends {
        Update: infer U
      }
      ? U
      : never
    : never

export type Enums<
  DefaultSchemaEnumNameOrOptions extends
    | keyof DefaultSchema["Enums"]
    | { schema: keyof DatabaseWithoutInternals },
  EnumName extends DefaultSchemaEnumNameOrOptions extends {
    schema: keyof DatabaseWithoutInternals
  }
    ? keyof DatabaseWithoutInternals[DefaultSchemaEnumNameOrOptions["schema"]]["Enums"]
    : never = never,
> = DefaultSchemaEnumNameOrOptions extends {
  schema: keyof DatabaseWithoutInternals
}
  ? DatabaseWithoutInternals[DefaultSchemaEnumNameOrOptions["schema"]]["Enums"][EnumName]
  : DefaultSchemaEnumNameOrOptions extends keyof DefaultSchema["Enums"]
    ? DefaultSchema["Enums"][DefaultSchemaEnumNameOrOptions]
    : never

export type CompositeTypes<
  PublicCompositeTypeNameOrOptions extends
    | keyof DefaultSchema["CompositeTypes"]
    | { schema: keyof DatabaseWithoutInternals },
  CompositeTypeName extends PublicCompositeTypeNameOrOptions extends {
    schema: keyof DatabaseWithoutInternals
  }
    ? keyof DatabaseWithoutInternals[PublicCompositeTypeNameOrOptions["schema"]]["CompositeTypes"]
    : never = never,
> = PublicCompositeTypeNameOrOptions extends {
  schema: keyof DatabaseWithoutInternals
}
  ? DatabaseWithoutInternals[PublicCompositeTypeNameOrOptions["schema"]]["CompositeTypes"][CompositeTypeName]
  : PublicCompositeTypeNameOrOptions extends keyof DefaultSchema["CompositeTypes"]
    ? DefaultSchema["CompositeTypes"][PublicCompositeTypeNameOrOptions]
    : never

export const Constants = {
  public: {
    Enums: {
      activity_direction: ["inbound", "outbound", "log"],
      activity_type: ["email", "sms", "call", "system"],
      app_role: ["admin", "manager", "user"],
      contact_status: ["lead", "prospect", "customer", "churned"],
      custom_field_type: ["text", "number", "date", "boolean", "select"],
      task_priority: ["low", "medium", "high"],
      task_status: ["pending", "completed", "overdue"],
      task_type: ["call", "email", "meeting", "follow-up", "other"],
    },
  },
} as const
