import { cn } from '@/lib/utils';
import { ContactStatus } from '@/lib/types';

interface StatusBadgeProps {
  status: ContactStatus;
  className?: string;
}

const statusConfig: Record<ContactStatus, { label: string; className: string }> = {
  lead: {
    label: 'Lead',
    className: 'bg-status-lead/10 text-status-lead border-status-lead/20',
  },
  prospect: {
    label: 'Prospect',
    className: 'bg-status-prospect/10 text-status-prospect border-status-prospect/20',
  },
  customer: {
    label: 'Customer',
    className: 'bg-status-customer/10 text-status-customer border-status-customer/20',
  },
  churned: {
    label: 'Churned',
    className: 'bg-status-churned/10 text-status-churned border-status-churned/20',
  },
};

export function StatusBadge({ status, className }: StatusBadgeProps) {
  const config = statusConfig[status];

  return (
    <span
      className={cn(
        'inline-flex items-center rounded-full border px-2.5 py-0.5 text-xs font-medium',
        config.className,
        className
      )}
    >
      {config.label}
    </span>
  );
}
