// /home/cre8ti10/react.blackstonesresidential.com/src/components/LoadingSpinner.tsx

import { Loader2 } from "lucide-react";
import React from "react";

interface LoadingSpinnerProps {
    message?: string;
    size?: 'sm' | 'md' | 'lg'; // Optional size prop
}

export const LoadingSpinner: React.FC<LoadingSpinnerProps> = ({ message = "Loading ...", size = 'md' }) => {
    // Define size classes
    const sizeClasses = {
        sm: 'h-6 w-6',
        md: 'h-10 w-10', // Default
        lg: 'h-16 w-16',
    };

    return (
        <div className="flex flex-col items-center justify-center">
            <Loader2 className={`${sizeClasses[size]} animate-spin text-primary mb-2`} />
            {message && <p className="text-sm font-medium text-muted-foreground">{message}</p>}
        </div>
    );
};