import { Outlet } from 'react-router-dom';
import { SidebarProvider, SidebarInset } from '@/components/ui/sidebar';
import { AppSidebar } from './AppSidebar';
import { AppTopNav } from './AppTopNav';
import { AppHeader } from './AppHeader';
import { useTheme } from '@/contexts/ThemeContext';
export function AppShell() {
  const {
    theme
  } = useTheme();
  const isTopbar = theme.layoutMode === 'topbar';
  if (isTopbar) {
    return <div className="min-h-screen flex flex-col w-full">
        <AppTopNav />
        <main className="flex-1 overflow-auto">
          <Outlet />
        </main>
        <footer className="border-t border-border px-6 py-4">
          <div className="flex items-center justify-between text-xs text-muted-foreground">
            <span>CRM Pro v1.0.0</span>
            <div className="flex items-center gap-4">
              <a href="#" className="hover:text-foreground transition-colors">Privacy</a>
              <a href="#" className="hover:text-foreground transition-colors">Terms</a>
              <a href="#" className="hover:text-foreground transition-colors">Support</a>
            </div>
          </div>
        </footer>
      </div>;
  }
  return <SidebarProvider>
      <div className="flex min-h-screen w-full">
        <AppSidebar />
        <SidebarInset className="flex flex-1 flex-col">
          <AppHeader />
          <main className="flex-1 overflow-auto">
            <Outlet />
          </main>
          <footer className="border-t border-border px-6 py-4">
            <div className="flex items-center justify-between text-xs text-muted-foreground">
              <span>SOHA LetFlow Pro v1.0.0</span>
              <div className="flex items-center gap-4">
                <a href="#" className="hover:text-foreground transition-colors">Privacy</a>
                <a href="#" className="hover:text-foreground transition-colors">Terms</a>
                <a href="#" className="hover:text-foreground transition-colors">Get Support</a>
              </div>
            </div>
          </footer>
        </SidebarInset>
      </div>
    </SidebarProvider>;
}