import { Toaster } from "@/components/ui/toaster";
import { Toaster as Sonner } from "@/components/ui/sonner";
import { TooltipProvider } from "@/components/ui/tooltip";
import { QueryClient, QueryClientProvider } from "@tanstack/react-query";
import { BrowserRouter, Routes, Route } from "react-router-dom";
import { ThemeProvider } from "@/contexts/ThemeContext";
import { AuthProvider } from "@/contexts/AuthContext";
import { ProtectedRoute } from "@/components/auth/ProtectedRoute";
import { AppShell } from "@/components/layout/AppShell";
import Login from "@/pages/Login";
import Dashboard from "@/pages/Dashboard";
import Contacts from "@/pages/Contacts";
import ContactDetail from "@/pages/ContactDetail";
import Properties from "@/pages/Properties";
import PropertyDetail from "@/pages/PropertyDetail";
import Tenancies from "@/pages/Tenancies";
import TenancyDetail from "@/pages/TenancyDetail";
import Pipelines from "@/pages/Pipelines";
import Tasks from "@/pages/Tasks";
import Trash from "@/pages/Trash";
import AppearanceSettings from "@/pages/settings/Appearance";
import CustomFieldsSettings from "@/pages/settings/CustomFields";
import TagsSettings from "@/pages/settings/Tags";
import BusinessSettings from "@/pages/settings/Business";
import EmailConfigSettings from "@/pages/settings/EmailConfig";
import EmailTemplatesSettings from "@/pages/settings/EmailTemplates";
import EmailCampaigns from "@/pages/settings/EmailCampaigns";
import NotFound from "@/pages/NotFound";

const queryClient = new QueryClient();

const App = () => (
  <QueryClientProvider client={queryClient}>
    <ThemeProvider>
      <AuthProvider>
        <TooltipProvider>
          <Toaster />
          <Sonner />
          <BrowserRouter>
            <Routes>
              <Route path="/login" element={<Login />} />
              <Route
                path="/"
                element={
                  <ProtectedRoute>
                    <AppShell />
                  </ProtectedRoute>
                }
              >
                <Route index element={<Dashboard />} />
                <Route path="contacts" element={<Contacts />} />
                <Route path="contacts/:id" element={<ContactDetail />} />
                <Route path="properties" element={<Properties />} />
                <Route path="properties/:id" element={<PropertyDetail />} />
                <Route path="tenancies" element={<Tenancies />} />
                <Route path="tenancies/:id" element={<TenancyDetail />} />
                <Route path="pipelines" element={<Pipelines />} />
                <Route path="tasks" element={<Tasks />} />
                <Route path="trash" element={<Trash />} />
                <Route path="settings/appearance" element={<AppearanceSettings />} />
                <Route path="settings/custom-fields" element={<CustomFieldsSettings />} />
                <Route path="settings/tags" element={<TagsSettings />} />
                <Route path="settings/business" element={<BusinessSettings />} />
                <Route path="settings/email" element={<EmailConfigSettings />} />
                <Route path="settings/email-templates" element={<EmailTemplatesSettings />} />
                <Route path="settings/campaigns" element={<EmailCampaigns />} />
              </Route>
              <Route path="*" element={<NotFound />} />
            </Routes>
          </BrowserRouter>
        </TooltipProvider>
      </AuthProvider>
    </ThemeProvider>
  </QueryClientProvider>
);

export default App;
